# Łamanie szyfru Vigenère’a za pomocą ataku słownikowego:
# https://www.nostarch.com/crackingcodes/ (na licencji BSD).

import detectEnglish, vigenereCipher, pyperclip

def main():
    ciphertext = """Tzx isnz eccjxkg nfq lol mys bbqq I lxcz."""
    hackedMessage = hackVigenereDictionary(ciphertext)

    if hackedMessage != None:
        print('Deszyfrowana wiadomość została skopiowana do schowka:')
        print(hackedMessage)
        pyperclip.copy(hackedMessage)
    else:
        print('Deszyfrowanie zakończyło się niepowodzeniem.')


def hackVigenereDictionary(ciphertext):
    fo = open('dictionary.txt')
    words = fo.readlines()
    fo.close()

    for word in words:
        word = word.strip() # Usunięcie znaku nowego wiersza na końcu słowa.
        decryptedText = vigenereCipher.decryptMessage(word, ciphertext)
        if detectEnglish.isEnglish(decryptedText, wordPercentage=40):
            # Użytkownik powinien potwierdzić, czy tekst został deszyfrowany prawidłowo.
            print()
            print('Potencjalnie udane złamanie szyfru:')
            print('Klucz ' + str(word) + ': ' + decryptedText[:100])
            print()
            print('Wpisz D, aby zakończyć. Dowolny inny klawisz kontynuuje łamanie szyfru:')
            response = input('> ')

            if response.upper().startswith('D'):
                return decryptedText

if __name__ == '__main__':
    main()
